# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
from mozperftest.layers import Layers
from mozperftest.system.proxy import ProxyRunner
from mozperftest.system.android import AndroidDevice


def get_layers():
    return (ProxyRunner, AndroidDevice)


def pick_system(env, flavor, mach_cmd):
    if flavor == "desktop-browser":
        return Layers(env, mach_cmd, (ProxyRunner,))
    if flavor == "mobile-browser":
        return Layers(env, mach_cmd, (ProxyRunner, AndroidDevice))
    raise NotImplementedError(flavor)
