/*
 * Decompiled with CFR 0.152.
 */
package jep;

import apple.awt.GraphicsClipper;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SimpleLayout;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import jep.AppletHolderContext;
import jep.AppletHolderFactory;
import jep.AppletHolderPanel;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.plugin.AppletViewer;

public class AppletHolder
extends Frame {
    protected static boolean showDebugInfo = false;
    protected long cocoaParentView = 0L;
    protected URL url = null;
    protected AppletViewer panel = null;
    protected HashSet clipperTable = new HashSet();
    public boolean isCarbonApp = true;
    public boolean updatesOff = false;
    public boolean asyncUpdatesOff = false;
    public boolean isInvisible = false;
    public boolean destroying = false;
    public Rectangle currentClip = null;
    public final TimedLock clipLock = new TimedLock();
    protected Rectangle initialAppletBounds = null;
    protected Rectangle savedAppletBounds = null;
    public int imposeClipCount = 0;
    public int removeClipCount = 0;

    public AppletHolder() {
    }

    public AppletHolder(long cocoaParentView, URL docbase, HashMap attributes, boolean isCarbonApp, boolean isInvisible) {
        this.cocoaParentView = cocoaParentView;
        this.url = docbase;
        this.panel = new AppletHolderPanel(docbase, attributes, this);
        this.add((Component)this.panel);
        this.initialAppletBounds = new Rectangle(0, 0, this.panel.getWidth(), this.panel.getHeight());
        this.setBounds(this.initialAppletBounds);
        this.panel.setBounds(this.initialAppletBounds);
        this.panel.setAppletContext((AppletContext)((Object)new AppletHolderContext(this)));
        this.currentClip = new Rectangle(this.initialAppletBounds);
        this.isCarbonApp = isCarbonApp;
        this.isInvisible = isInvisible;
    }

    protected void displayAllComponents(Component[] components, String indent) {
        for (int i = 1; i <= components.length; ++i) {
            System.err.println(indent + components[i - 1].toString());
            try {
                this.displayAllComponents(((Container)components[i - 1]).getComponents(), new String(indent) + "--");
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
    }

    public void showAppletInfo() {
        Component[] components = this.getComponents();
        System.err.println("AppletHolder showAppletInfo(): Self and all components:");
        System.err.println("--" + this.toString());
        this.displayAllComponents(components, "----");
        AllPermission perm = new AllPermission();
        try {
            AccessController.checkPermission(perm);
            System.err.println("AppletHolder: showAppletInfo(): We've got AllPermission");
        }
        catch (AccessControlException e) {
            System.err.println("AppletHolder: showAppletInfo(): We don't have AllPermission");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClipper(GraphicsClipper clipper) {
        HashSet hashSet = this.clipperTable;
        synchronized (hashSet) {
            this.cleanClipperTable();
            this.clipperTable.add(clipper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClipper(GraphicsClipper clipper) {
        HashSet hashSet = this.clipperTable;
        synchronized (hashSet) {
            Iterator iterator = this.clipperTable.iterator();
            while (iterator.hasNext()) {
                GraphicsClipper item = (GraphicsClipper)iterator.next();
                if (item.getGraphics() == null) {
                    iterator.remove();
                    continue;
                }
                if (!item.equals(clipper)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanClipperTable() {
        HashSet hashSet = this.clipperTable;
        synchronized (hashSet) {
            Iterator iterator = this.clipperTable.iterator();
            while (iterator.hasNext()) {
                GraphicsClipper item = (GraphicsClipper)iterator.next();
                if (item.getGraphics() != null) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateClips() {
        if (this.destroying) {
            return;
        }
        HashSet hashSet = this.clipperTable;
        synchronized (hashSet) {
            Iterator iterator = this.clipperTable.iterator();
            while (iterator.hasNext()) {
                GraphicsClipper item = (GraphicsClipper)iterator.next();
                if (item.getGraphics() == null) {
                    iterator.remove();
                    continue;
                }
                item.validateDevClip();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zeroClips() {
        if (this.destroying) {
            return;
        }
        HashSet hashSet = this.clipperTable;
        synchronized (hashSet) {
            Iterator iterator = this.clipperTable.iterator();
            while (iterator.hasNext()) {
                GraphicsClipper item = (GraphicsClipper)iterator.next();
                if (item.getGraphics() == null) {
                    iterator.remove();
                    continue;
                }
                item.zeroDevClip();
            }
        }
    }

    public AppletViewer getPanel() {
        return this.panel;
    }

    public Applet getApplet() {
        return this.panel.getApplet();
    }

    public int getLoadingStatus() {
        return this.panel.getLoadingStatus();
    }

    public void validate() {
        if (this.destroying || AppletHolderFactory.isMainThread()) {
            return;
        }
        super.validate();
    }

    public void invalidate() {
        if (this.destroying || AppletHolderFactory.isMainThread()) {
            return;
        }
        super.invalidate();
    }

    public void validateApplet() {
        if (this.destroying) {
            return;
        }
        AppContext context = null;
        Container target = null;
        Applet applet = this.getApplet();
        target = applet != null ? applet : this;
        context = SunToolkit.targetToAppContext(target);
        boolean isOurContext = AppContext.getAppContext().equals(context);
        if (isOurContext && !AppletHolderFactory.isMainThread()) {
            this.validate();
        } else {
            SunToolkit.postEvent(context, new PeerEvent(target, new Validate(this), 1L));
        }
    }

    public void invalidateAndValidate() {
        if (this.destroying) {
            return;
        }
        AppContext context = null;
        Container target = null;
        Applet applet = this.getApplet();
        target = applet != null ? applet : this;
        context = SunToolkit.targetToAppContext(target);
        boolean isOurContext = AppContext.getAppContext().equals(context);
        if (isOurContext && !AppletHolderFactory.isMainThread()) {
            if (applet != null) {
                applet.invalidate();
            } else {
                this.getPanel().invalidate();
            }
            this.validate();
            return;
        }
        SunToolkit.postEvent(context, new PeerEvent(target, new InvalidateAndValidate(this), 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppletVisible(boolean visible, boolean flagOnly, boolean wait) {
        if (this.destroying) {
            return;
        }
        Applet applet = this.getApplet();
        if (applet == null || flagOnly || !wait) {
            boolean visibilityChanged = visible == this.isInvisible;
            boolean bl = this.isInvisible = !visible;
            if (visibilityChanged) {
                if (this.isInvisible) {
                    this.zeroClips();
                } else {
                    this.validateClips();
                }
            }
            if (applet == null || flagOnly) {
                return;
            }
        }
        AppContext appletContext = SunToolkit.targetToAppContext(applet);
        boolean isAppletContext = AppContext.getAppContext().equals(appletContext);
        if (isAppletContext) {
            this.setAppletVisibleDirectly(applet, visible);
        } else {
            Done done;
            Done done2 = done = new Done();
            synchronized (done2) {
                SunToolkit.postEvent(appletContext, new PeerEvent(applet, new SetVisible(this, visible, done), 1L));
                if (wait) {
                    try {
                        done.wait(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void setAppletVisibleDirectly(Applet applet, boolean visible) {
        boolean visibilityChanged;
        if (this.destroying) {
            return;
        }
        boolean bl = visibilityChanged = visible == this.isInvisible;
        if (applet == null) {
            boolean bl2 = this.isInvisible = !visible;
            if (visibilityChanged) {
                if (this.isInvisible) {
                    this.zeroClips();
                } else {
                    this.validateClips();
                }
            }
            return;
        }
        if (this.savedAppletBounds != null) {
            if (visible) {
                this.imposeClipDirectly(this.currentClip.x, this.currentClip.y, this.currentClip.width, this.currentClip.height);
            } else {
                this.removeClipTemporarily();
            }
        }
        applet.setVisible(visible);
        boolean bl3 = this.isInvisible = !applet.isVisible();
        if (visibilityChanged) {
            if (this.isInvisible) {
                this.zeroClips();
            } else {
                this.validateClips();
            }
        }
    }

    public Rectangle getAppletBounds() {
        try {
            if (this.savedAppletBounds != null) {
                return new Rectangle(this.savedAppletBounds);
            }
            Applet applet = this.getApplet();
            if (applet != null) {
                return applet.getBounds();
            }
            return new Rectangle(this.initialAppletBounds);
        }
        catch (Throwable e) {
            return new Rectangle(this.initialAppletBounds);
        }
    }

    public void setAppletBounds(int x, int y, int width, int height) {
        Applet applet = this.getApplet();
        if (applet == null) {
            return;
        }
        applet.setBounds(x, y, width, height);
    }

    public void setAppletBounds(Rectangle bounds) {
        Applet applet = this.getApplet();
        if (applet == null) {
            return;
        }
        applet.setBounds(bounds);
    }

    public void resetInitialAppletBounds(Rectangle bounds) {
        if (this.destroying) {
            return;
        }
        if (!this.clipLock.lock(1000L)) {
            System.err.println("AppletHolder.resetInitialAppletBounds(): lock timed out");
            Throwable barf = new Throwable();
            barf.fillInStackTrace();
            barf.printStackTrace();
            return;
        }
        this.initialAppletBounds = new Rectangle(bounds);
        this.currentClip = new Rectangle(bounds);
        this.savedAppletBounds = null;
        this.clipLock.unlock();
    }

    public void resizeApplet(int width, int height) {
        if (this.destroying) {
            return;
        }
        Applet applet = this.getApplet();
        if (width == 0 || height == 0 || applet == null) {
            return;
        }
        if (!AppletHolderFactory.isJava142Update1()) {
            this.panel.appletResize(width, height);
            return;
        }
        AppContext appletContext = SunToolkit.targetToAppContext(applet);
        boolean isAppletContext = AppContext.getAppContext().equals(appletContext);
        if (isAppletContext) {
            this.panel.appletResize(width, height);
        } else {
            SunToolkit.postEvent(appletContext, new PeerEvent(applet, new ResizeApplet(this, width, height), 1L));
        }
    }

    public void setSimpleLayout() {
        if (this.destroying) {
            return;
        }
        this.setLayout(new SimpleLayout(this.panel.getWidth(), this.panel.getHeight(), this));
        this.panel.setLayout((LayoutManager)new SimpleLayout(this.panel.getWidth(), this.panel.getHeight(), this));
    }

    public void setIgnoreRepaint(boolean flag) {
        super.setIgnoreRepaint(flag);
        this.panel.setIgnoreRepaint(flag);
        Applet applet = this.getApplet();
        if (applet == null) {
            return;
        }
        applet.setIgnoreRepaint(flag);
    }

    public void setUpdatesOff(boolean b) {
        boolean changed;
        if (showDebugInfo) {
            if (b && !this.updatesOff) {
                System.err.println("AppletHolder: Turning updates off");
            } else if (!b && this.updatesOff) {
                System.err.println("AppletHolder: Turning updates on");
            }
        }
        this.updatesOff = b;
        boolean bl = changed = this.updatesOff != b;
        if (this.updatesOff) {
            if (changed) {
                this.zeroClips();
            }
            this.setAsyncUpdatesOff(true);
        }
    }

    public void setAsyncUpdatesOff(boolean b) {
        if (showDebugInfo) {
            if (b && !this.asyncUpdatesOff) {
                System.err.println("AppletHolder: Turning async updates off");
            } else if (!b && this.asyncUpdatesOff) {
                System.err.println("AppletHolder: Turning async updates on");
            }
        }
        boolean changed = this.asyncUpdatesOff != b;
        this.asyncUpdatesOff = b;
        if (!this.asyncUpdatesOff && changed) {
            this.validateClips();
        }
    }

    public Rectangle translateCurrentClip(Component componentToClip) {
        Rectangle translatedClip;
        if (this.destroying) {
            return new Rectangle();
        }
        AppletHolderFactory.disableScreenUpdates();
        try {
            if (componentToClip.equals(this.panel)) {
                componentToClip = this;
            } else if (componentToClip.equals(this.getApplet())) {
                componentToClip = this;
            }
            Component comp = componentToClip;
            Point compLocation = comp.getLocation();
            int xDiff = compLocation.x;
            int yDiff = compLocation.y;
            while (!comp.equals(this)) {
                Container parent = comp.getParent();
                if (parent.equals(this.panel)) {
                    parent = this;
                } else if (parent.equals(this.getApplet())) {
                    parent = this;
                }
                if (!parent.equals(this)) {
                    Point parentLocation = parent.getLocation();
                    xDiff += parentLocation.x;
                    yDiff += parentLocation.y;
                }
                comp = parent;
            }
            translatedClip = new Rectangle(this.currentClip);
            if (translatedClip.width >= 0 && translatedClip.height >= 0) {
                translatedClip.x -= xDiff;
                translatedClip.y -= yDiff;
            }
        }
        catch (Throwable e) {
            translatedClip = new Rectangle();
        }
        AppletHolderFactory.enableScreenUpdates();
        return translatedClip;
    }

    public void imposeClip(int clipX, int clipY, int clipWidth, int clipHeight) {
        if (this.destroying) {
            return;
        }
        if (!AppletHolderFactory.isJava142Update1()) {
            this.imposeClipDirectly(clipX, clipY, clipWidth, clipHeight);
            return;
        }
        AppContext context = null;
        Container target = null;
        Applet applet = this.getApplet();
        target = applet != null ? applet : this;
        context = SunToolkit.targetToAppContext(target);
        boolean isOurContext = AppContext.getAppContext().equals(context);
        if (isOurContext && !AppletHolderFactory.isMainThread()) {
            this.imposeClipDirectly(clipX, clipY, clipWidth, clipHeight);
        } else {
            if (++this.imposeClipCount == 1) {
                AppletHolderFactory.suspendAppletUpdates(this.getCocoaParentViewLong());
            }
            SunToolkit.postEvent(context, new PeerEvent(target, new ImposeClip(this, clipX, clipY, clipWidth, clipHeight), 1L));
        }
    }

    public void imposeClipDirectly(int clipX, int clipY, int clipWidth, int clipHeight) {
        if (this.destroying) {
            return;
        }
        if (!this.clipLock.lock(1000L)) {
            System.err.println("AppletHolder.imposeClip(): lock timed out");
            Throwable barf = new Throwable();
            barf.fillInStackTrace();
            barf.printStackTrace();
            return;
        }
        if (this.savedAppletBounds == null) {
            this.savedAppletBounds = this.getAppletBounds();
        }
        if (clipX == this.savedAppletBounds.x && clipY == this.savedAppletBounds.y && clipWidth == this.savedAppletBounds.width && clipHeight == this.savedAppletBounds.height) {
            this.removeClipDirectly();
        } else {
            if (clipX == this.currentClip.x && clipY == this.currentClip.y && clipWidth == this.currentClip.width && clipHeight == this.currentClip.height) {
                this.validateApplet();
                this.clipLock.unlock();
                return;
            }
            Applet applet = this.getApplet();
            if (applet != null) {
                if (AppletHolderFactory.isJava142Update1()) {
                    this.panel.setBounds(clipX, clipY, this.savedAppletBounds.width, this.savedAppletBounds.height);
                } else {
                    this.panel.setBounds(clipX, clipY + 22, this.savedAppletBounds.width, this.savedAppletBounds.height);
                }
                this.setAppletBounds(-clipX, -clipY, this.savedAppletBounds.width, this.savedAppletBounds.height);
            } else if (AppletHolderFactory.isJava142Update1()) {
                this.panel.setBounds(0, 0, this.savedAppletBounds.width, this.savedAppletBounds.height);
            } else {
                this.panel.setBounds(0, 22, this.savedAppletBounds.width, this.savedAppletBounds.height);
            }
            this.currentClip = new Rectangle(clipX, clipY, clipWidth, clipHeight);
            this.invalidateAndValidate();
            this.validateClips();
            if (showDebugInfo) {
                this.showAppletInfo();
            }
        }
        this.clipLock.unlock();
    }

    public void removeClip() {
        if (this.destroying) {
            return;
        }
        if (!AppletHolderFactory.isJava142Update1()) {
            this.removeClipDirectly();
            return;
        }
        AppContext context = null;
        Container target = null;
        Applet applet = this.getApplet();
        target = applet != null ? applet : this;
        context = SunToolkit.targetToAppContext(target);
        boolean isOurContext = AppContext.getAppContext().equals(context);
        if (isOurContext && !AppletHolderFactory.isMainThread()) {
            this.removeClipDirectly();
        } else {
            if (++this.removeClipCount == 1) {
                AppletHolderFactory.suspendAppletUpdates(this.getCocoaParentViewLong());
            }
            SunToolkit.postEvent(context, new PeerEvent(target, new RemoveClip(this), 1L));
        }
    }

    public void removeClipDirectly() {
        if (this.destroying) {
            return;
        }
        Rectangle boundsToRestore = this.savedAppletBounds;
        if (boundsToRestore == null) {
            boundsToRestore = this.initialAppletBounds;
        }
        if (!this.clipLock.lock(1000L)) {
            System.err.println("AppletHolder.removeClip(): lock timed out");
            Throwable barf = new Throwable();
            barf.fillInStackTrace();
            barf.printStackTrace();
            return;
        }
        if (boundsToRestore.x == this.currentClip.x && boundsToRestore.y == this.currentClip.y && boundsToRestore.width == this.currentClip.width && boundsToRestore.height == this.currentClip.height) {
            this.validateApplet();
            this.clipLock.unlock();
            return;
        }
        if (AppletHolderFactory.isJava142Update1()) {
            this.panel.setBounds(0, 0, boundsToRestore.width, boundsToRestore.height);
        } else {
            this.panel.setBounds(0, 22, boundsToRestore.width, boundsToRestore.height);
        }
        this.setAppletBounds(boundsToRestore);
        this.savedAppletBounds = null;
        this.currentClip = new Rectangle(boundsToRestore);
        this.invalidateAndValidate();
        this.validateClips();
        if (showDebugInfo) {
            this.showAppletInfo();
        }
        this.clipLock.unlock();
    }

    protected void removeClipTemporarily() {
        if (!this.clipLock.lock(1000L)) {
            System.err.println("AppletHolder.removeClipTemporarily(): lock timed out");
            Throwable barf = new Throwable();
            barf.fillInStackTrace();
            barf.printStackTrace();
            return;
        }
        Rectangle boundsToRestore = this.savedAppletBounds;
        if (boundsToRestore == null) {
            boundsToRestore = this.initialAppletBounds;
        }
        if (AppletHolderFactory.isJava142Update1()) {
            this.panel.setBounds(0, 0, boundsToRestore.width, boundsToRestore.height);
        } else {
            this.panel.setBounds(0, 22, boundsToRestore.width, boundsToRestore.height);
        }
        this.setAppletBounds(boundsToRestore);
        this.clipLock.unlock();
    }

    public void activateHolder() {
        this.pack();
        this.setVisible(true);
    }

    public void initApplet() {
        this.panel.appletInit();
    }

    public void startApplet() {
        if (this.destroying) {
            return;
        }
        this.panel.appletStart();
        this.isInvisible = false;
        if (showDebugInfo) {
            this.showAppletInfo();
        }
    }

    public void stopApplet() {
        if (this.destroying) {
            return;
        }
        this.panel.appletStop();
        this.isInvisible = true;
    }

    public void appletStartApplet() {
        if (this.destroying) {
            return;
        }
        Applet applet = this.getApplet();
        if (applet == null) {
            return;
        }
        AppContext appletContext = SunToolkit.targetToAppContext(applet);
        boolean isAppletContext = AppContext.getAppContext().equals(appletContext);
        if (isAppletContext) {
            this.appletStartAppletDirectly(applet);
            return;
        }
        SunToolkit.postEvent(appletContext, new PeerEvent(applet, new AppletStartApplet(this), 1L));
    }

    public void appletStartAppletDirectly(Applet applet) {
        if (applet == null || this.destroying) {
            return;
        }
        this.setAppletVisibleDirectly(applet, true);
        applet.start();
    }

    public void appletStopApplet() {
        if (this.destroying) {
            return;
        }
        Applet applet = this.getApplet();
        if (applet == null) {
            return;
        }
        AppContext appletContext = SunToolkit.targetToAppContext(applet);
        boolean isAppletContext = AppContext.getAppContext().equals(appletContext);
        if (isAppletContext) {
            this.appletStopAppletDirectly(applet);
            return;
        }
        SunToolkit.postEvent(appletContext, new PeerEvent(applet, new AppletStopApplet(this), 1L));
    }

    public void appletStopAppletDirectly(Applet applet) {
        if (applet == null || this.destroying) {
            return;
        }
        this.setAppletVisibleDirectly(applet, false);
        applet.stop();
    }

    protected void setAllComponentsInvisible(Component[] components) {
        for (int i = 1; i <= components.length; ++i) {
            components[i - 1].setVisible(false);
            try {
                this.setAllComponentsInvisible(((Container)components[i - 1]).getComponents());
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    protected void disableAllComponents(Component[] components) {
        for (int i = 1; i <= components.length; ++i) {
            components[i - 1].setEnabled(false);
            try {
                this.disableAllComponents(((Container)components[i - 1]).getComponents());
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void destroyApplet() {
        if (this.destroying) {
            return;
        }
        this.destroying = true;
        long prevCocoaParentView = this.cocoaParentView;
        this.cocoaParentView = 0L;
        this.isInvisible = true;
        Applet applet = this.getApplet();
        if (AppletHolderFactory.getPropertyBoolean("jep.debug.release", false)) {
            System.out.println(new Date() + " AppletHolder.destroyApplet() for " + (applet != null ? applet.getClass().getName() : "0x" + Long.toHexString(prevCocoaParentView)));
        }
        if (applet == null) {
            this.dispose();
            return;
        }
        AppContext appletContext = SunToolkit.targetToAppContext(applet);
        boolean isAppletContext = AppContext.getAppContext().equals(appletContext);
        if (isAppletContext) {
            this.destroyAppletDirectly1();
            return;
        }
        SunToolkit.postEvent(appletContext, new PeerEvent(applet, new Destroy1(this), 1L));
    }

    public void destroyAppletDirectly1() {
        this.destroying = true;
        this.cocoaParentView = 0L;
        this.isInvisible = true;
        this.panel.setVisible(false);
        Component[] components = this.panel.getComponents();
        if (components != null) {
            this.setAllComponentsInvisible(components);
            this.disableAllComponents(components);
        }
        this.panel.setEnabled(false);
        SunToolkit.postEvent(AppletHolderFactory.mainAppContext, new PeerEvent(this.getApplet(), new Destroy2(this), 1L));
    }

    public void destroyAppletDirectly2() {
        this.panel.appletDestroy();
        this.dispose();
    }

    public int getCocoaParentViewInt() {
        return (int)this.cocoaParentView;
    }

    public long getCocoaParentViewLong() {
        return this.cocoaParentView;
    }

    public void changeFrameAppContext(AppContext appcontext) {
        SunToolkit.insertTargetMapping(this, appcontext);
        SunToolkit.insertTargetMapping(this.panel, appcontext);
    }

    public AppletContext getAppletContext() {
        return this.panel.getAppletContext();
    }

    public String toString() {
        return super.toString() + " (jep)";
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("jep.debuginfo", "false"))) {
            showDebugInfo = true;
        }
    }

    private class Destroy2
    implements Runnable {
        private final AppletHolder holder;

        Destroy2(AppletHolder holder) {
            this.holder = holder;
        }

        public void run() {
            this.holder.destroyAppletDirectly2();
            if (showDebugInfo) {
                System.err.println("AppletHolder Destroy2 run() called");
            }
        }
    }

    private class Destroy1
    implements Runnable {
        private final AppletHolder holder;

        Destroy1(AppletHolder holder) {
            this.holder = holder;
        }

        public void run() {
            this.holder.destroyAppletDirectly1();
            if (showDebugInfo) {
                System.err.println("AppletHolder Destroy1 run() called");
            }
        }
    }

    private class RemoveClip
    implements Runnable {
        private final AppletHolder holder;

        RemoveClip(AppletHolder holder) {
            this.holder = holder;
        }

        public void run() {
            if (--AppletHolder.this.removeClipCount == 0) {
                this.holder.removeClipDirectly();
                AppletHolderFactory.resumeAppletUpdates(this.holder.getCocoaParentViewLong());
            } else if (AppletHolder.this.removeClipCount < 0) {
                AppletHolder.this.removeClipCount = 0;
            }
            if (showDebugInfo) {
                System.err.println("AppletHolder RemoveClip run() called");
            }
        }
    }

    private class ImposeClip
    implements Runnable {
        private final AppletHolder holder;
        private final int clipX;
        private final int clipY;
        private final int clipWidth;
        private final int clipHeight;

        ImposeClip(AppletHolder holder, int clipX, int clipY, int clipWidth, int clipHeight) {
            this.holder = holder;
            this.clipX = clipX;
            this.clipY = clipY;
            this.clipWidth = clipWidth;
            this.clipHeight = clipHeight;
        }

        public void run() {
            if (--AppletHolder.this.imposeClipCount == 0) {
                this.holder.imposeClipDirectly(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
                AppletHolderFactory.resumeAppletUpdates(this.holder.getCocoaParentViewLong());
            } else if (AppletHolder.this.imposeClipCount < 0) {
                AppletHolder.this.imposeClipCount = 0;
            }
            if (showDebugInfo) {
                System.err.println("AppletHolder ImposeClip run() called");
            }
        }
    }

    private class AppletStopApplet
    implements Runnable {
        private final AppletHolder holder;

        AppletStopApplet(AppletHolder holder) {
            this.holder = holder;
        }

        public void run() {
            this.holder.appletStopAppletDirectly(this.holder.getApplet());
            if (showDebugInfo) {
                System.err.println("AppletHolder AppletStopApplet run() called");
            }
        }
    }

    private class AppletStartApplet
    implements Runnable {
        private final AppletHolder holder;

        AppletStartApplet(AppletHolder holder) {
            this.holder = holder;
        }

        public void run() {
            this.holder.appletStartAppletDirectly(this.holder.getApplet());
            if (showDebugInfo) {
                System.err.println("AppletHolder AppletStartApplet run() called");
            }
        }
    }

    private class ResizeApplet
    implements Runnable {
        private final AppletHolder holder;
        private final int width;
        private final int height;

        ResizeApplet(AppletHolder holder, int newWidth, int newHeight) {
            this.holder = holder;
            this.width = newWidth;
            this.height = newHeight;
        }

        public void run() {
            this.holder.getPanel().appletResize(this.width, this.height);
            if (showDebugInfo) {
                System.err.println("AppletHolder ResizeApplet run() called, width is " + String.valueOf(this.width) + " height is " + String.valueOf(this.height));
            }
        }
    }

    private class SetVisible
    implements Runnable {
        private final AppletHolder holder;
        private final boolean flag;
        private Done done;

        SetVisible(AppletHolder holder, boolean flag, Done done) {
            this.holder = holder;
            this.flag = flag;
            this.done = done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Done done = this.done;
            synchronized (done) {
                this.holder.setAppletVisibleDirectly(this.holder.getApplet(), this.flag);
                this.done.setDone();
                this.done.notifyAll();
            }
            if (showDebugInfo) {
                System.err.println("AppletHolder SetVisible run() called, flag is " + (this.flag ? "true" : "false"));
            }
        }
    }

    private class InvalidateAndValidate
    implements Runnable {
        private final AppletHolder holder;

        InvalidateAndValidate(AppletHolder holder) {
            this.holder = holder;
        }

        public void run() {
            Applet applet = this.holder.getApplet();
            if (applet != null) {
                applet.invalidate();
            } else {
                this.holder.getPanel().invalidate();
            }
            this.holder.validate();
            if (showDebugInfo) {
                System.err.println("AppletHolder InvalidateAndValidate run() called on " + this.holder.toString());
            }
        }
    }

    private class Validate
    implements Runnable {
        private final AppletHolder holder;

        Validate(AppletHolder holder) {
            this.holder = holder;
        }

        public void run() {
            this.holder.validate();
            if (showDebugInfo) {
                System.err.println("AppletHolder Validate run() called on " + this.holder.toString());
            }
        }
    }

    private class Done {
        private boolean done = false;

        public void setDone() {
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }
    }

    public class TimedLock {
        private Stack lockStack = new Stack();

        public void lock() {
            this.lock(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean lock(long timeout) {
            Thread newLock = null;
            Thread firstLock = null;
            Object object = this.lockStack;
            synchronized (object) {
                try {
                    firstLock = (Thread)this.lockStack.elementAt(0);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                newLock = Thread.currentThread();
                this.lockStack.push(newLock);
                if (firstLock == null) {
                    return true;
                }
                if (newLock.equals(firstLock)) {
                    return true;
                }
            }
            object = newLock;
            synchronized (object) {
                try {
                    newLock.wait(timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            object = this.lockStack;
            synchronized (object) {
                try {
                    firstLock = (Thread)this.lockStack.elementAt(0);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    firstLock = null;
                }
                if (firstLock == null) {
                    System.err.println("AppletHolder.TimedLock.lock(): Lock stack is empty!");
                    Throwable barf = new Throwable();
                    barf.fillInStackTrace();
                    barf.printStackTrace();
                    return false;
                }
                Thread currentThread = Thread.currentThread();
                if (!currentThread.equals(firstLock)) {
                    for (int i = this.lockStack.size(); i >= 2; --i) {
                        Thread lock = (Thread)this.lockStack.elementAt(i - 1);
                        if (!currentThread.equals(lock)) continue;
                        this.lockStack.removeElementAt(i - 1);
                    }
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean trylock() {
            Stack stack = this.lockStack;
            synchronized (stack) {
                Thread firstLock = null;
                try {
                    firstLock = (Thread)this.lockStack.elementAt(0);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (firstLock == null) {
                    this.lock();
                    return true;
                }
                if (Thread.currentThread().equals(firstLock)) {
                    this.lock();
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock() {
            Stack stack = this.lockStack;
            synchronized (stack) {
                int currentThreadLockCount = 0;
                Thread currentThread = Thread.currentThread();
                for (int i = this.lockStack.size(); i >= 1; --i) {
                    Thread lock = (Thread)this.lockStack.elementAt(i - 1);
                    if (!currentThread.equals(lock) || ++currentThreadLockCount != 1) continue;
                    this.lockStack.removeElementAt(i - 1);
                }
                if (currentThreadLockCount >= 2) {
                    return;
                }
                if (currentThreadLockCount == 0) {
                    System.err.println("AppletHolder.TimedLock.unlock() called without matching call to lock()!");
                    Throwable barf = new Throwable();
                    barf.fillInStackTrace();
                    barf.printStackTrace();
                    return;
                }
                if (!this.lockStack.empty()) {
                    Thread firstLock;
                    Thread thread = firstLock = (Thread)this.lockStack.elementAt(0);
                    synchronized (thread) {
                        firstLock.notify();
                    }
                }
            }
        }
    }
}

