//@line 37 "/export/home/mozilla/uild/thunderbird1.5b1/mozilla/mail/components/preferences/defaultClient.js"

const kMailApp = 1;
const kNewsApp = 2;
const kFeedApp = 3;

var gDefaultClientPane = {
  mMapiBundle: null,
  mBrandBundle: null,

  init: function ()
  {
    this.mBrandBundle = document.getElementById("brandBundle");
    this.mMapiBundle = document.getElementById("mapiBundle");
  },

  checkDefaultAppNow: function (appType) 
  {
    var mapiReg = Components.classes["@mozilla.org/mapiregistry;1"]
                            .getService(Components.interfaces.nsIMapiRegistry);

    var brandShortName = this.mBrandBundle.getString("brandShortName");
    var promptTitle = this.mMapiBundle
                          .getFormattedString("dialogTitle", [brandShortName]);
    var promptMessage;
    var IPS = Components.interfaces.nsIPromptService;
    var prompt = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                           .getService(IPS);

    var isDefault;
    var str;
    if (appType == kMailApp)
    {
      isDefault = mapiReg.isDefaultMailClient;
      str = "Mail";
    }
    else if (appType == kNewsApp)
    {
      isDefault = mapiReg.isDefaultNewsClient;
      str = "News";
    } 
    else if (appType == kFeedApp)
    {
      isDefault = mapiReg.isDefaultFeedClient;
      str = "Feed";
    }
    else {
      throw ("Invalid appType value passed to gGeneralPane.checkDefaultAppNow");
    }

    if (!isDefault) 
    {
      promptMessage = this.mMapiBundle.getFormattedString("setDefault" + str,
                                                    [brandShortName]);

      var rv = prompt.confirmEx(window, promptTitle, promptMessage,
                                (IPS.BUTTON_TITLE_YES * IPS.BUTTON_POS_0) +
                                (IPS.BUTTON_TITLE_NO * IPS.BUTTON_POS_1),
                                null, null, null, null, { });
      if (rv == 0) 
      {
        if (appType == kMailApp)
          mapiReg.isDefaultMailClient = true;
        else if (appType == kNewsApp)
          mapiReg.isDefaultNewsClient = true;
        else
          mapiReg.isDefaultFeedClient = true;
      }
    }
    else 
    {
      promptMessage = this.mMapiBundle.getFormattedString("alreadyDefault" + str,
                                                          [brandShortName]);

      prompt.alert(window, promptTitle, promptMessage);
    }
  }
};

