// For documentation of the format, see README in this directory.
var browserTests = [
["foo[]bar",
    [["hilitecolor","#00FFFF"]],
    "foo[]bar",
    [true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p> <p><span style=\"background-color:rgb(0, 255, 255)\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p> <p><span style=\"background-color:rgb(0, 255, 255)\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\"><span>[foo</span> <span>bar]</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\"><span>[foo</span> <span>bar]</span></span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p><p> <span style=\"background-color:rgb(0, 255, 255)\"><span>bar</span></span> </p><p><span style=\"background-color:rgb(0, 255, 255)\">baz]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p><p> <span style=\"background-color:rgb(0, 255, 255)\"><span>bar</span></span> </p><p><span style=\"background-color:rgb(0, 255, 255)\">baz]</span></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p><p><span style=\"background-color:rgb(0, 255, 255)\"><br></span></p><p><span style=\"background-color:rgb(0, 255, 255)\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p><p><span style=\"background-color:rgb(0, 255, 255)\"><br></span></p><p><span style=\"background-color:rgb(0, 255, 255)\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<b>foo[]bar</b>",
    [["hilitecolor","#00FFFF"]],
    "<b>foo[]bar</b>",
    [true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<i>foo[]bar</i>",
    [["hilitecolor","#00FFFF"]],
    "<i>foo[]bar</i>",
    [true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span>foo</span>{}<span>bar</span>",
    [["hilitecolor","#00FFFF"]],
    "<span>foo</span>{}<span>bar</span>",
    [true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span>foo[</span><span>]bar</span>",
    [["hilitecolor","#00FFFF"]],
    "<span>foo[</span><span>]bar</span>",
    [true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">[bar</span><b><span style=\"background-color:rgb(0, 255, 255)\">baz]</span>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">[bar</span><b><span style=\"background-color:rgb(0, 255, 255)\">baz]</span>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">[bar</span><i><span style=\"background-color:rgb(0, 255, 255)\">baz]</span>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">[bar</span><i><span style=\"background-color:rgb(0, 255, 255)\">baz]</span>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "{<p></p><p> </p><p><span style=\"background-color:rgb(0, 255, 255)\">foo</span></p>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "{<p></p><p> </p><p><span style=\"background-color:rgb(0, 255, 255)\">foo</span></p>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<table><tbody><tr><td>foo</td><td>b<span style=\"background-color:rgb(0, 255, 255)\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<table><tbody><tr><td>foo</td><td>b<span style=\"background-color:rgb(0, 255, 255)\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<table><tbody><tr><td>foo</td>{<td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<table><tbody><tr><td>foo</td>{<td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<table><tbody><tr>{<td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<table><tbody><tr>{<td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<table><tbody>{<tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<table><tbody>{<tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<table>{<tbody><tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<table>{<tbody><tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "{<table><tbody><tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "{<table><tbody><tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p style=\"background-color: rgb(0, 255, 255)\">foo[bar]baz</p>",
    [["hilitecolor","#00FFFF"]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</p>",
    [true],
    {"hilitecolor":[false,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["<p style=\"background-color: #00ffff\">foo[bar]baz</p>",
    [["hilitecolor","#00FFFF"]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</p>",
    [true],
    {"hilitecolor":[false,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["<p style=\"background-color: aqua\">foo[bar]baz</p>",
    [["hilitecolor","#00FFFF"]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</p>",
    [true],
    {"hilitecolor":[false,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["{<p style=\"background-color: aqua\">foo</p><p>bar</p>}",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "{<p style=\"background-color:rgb(0, 255, 255)\">foo</p><p><span style=\"background-color:rgb(0, 255, 255)\">bar</span></p>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[true,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["{<p style=\"background-color: aqua\">foo</p><p>bar</p>}",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "{<p style=\"background-color:rgb(0, 255, 255)\">foo</p><p><span style=\"background-color:rgb(0, 255, 255)\">bar</span></p>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[true,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: aqua\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: aqua\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: #00ffff\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: #00ffff\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: #0ff\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: #0ff\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: rgb(0, 255, 255)\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: rgb(0, 255, 255)\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: aqua\">foo<span style=\"background-color: tan\">b[ar]</span>baz</span>",
    [["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">foo<span style=\"background-color:rgb(210, 180, 140)\">b</span>[ar]baz</span>",
    [true],
    {"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<p style=\"background-color: aqua\">foo<span style=\"background-color: tan\">b[ar]</span>baz</p>",
    [["hilitecolor","#00FFFF"]],
    "<p style=\"background-color:rgb(0, 255, 255)\">foo<span style=\"background-color:rgb(210, 180, 140)\">b</span>[ar]baz</p>",
    [true],
    {"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<div style=\"background-color: aqua\"><p style=\"background-color: tan\">b[ar]</p></div>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<div style=\"background-color:rgb(0, 255, 255)\"><p style=\"background-color:rgb(210, 180, 140)\">b<span style=\"background-color:rgb(0, 255, 255)\">[ar]</span></p></div>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<div style=\"background-color: aqua\"><p style=\"background-color: tan\">b[ar]</p></div>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<div style=\"background-color:rgb(0, 255, 255)\"><p style=\"background-color:rgb(210, 180, 140)\">b<span style=\"background-color:rgb(0, 255, 255)\">[ar]</span></p></div>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"display: block; background-color: aqua\"><span style=\"display: block; background-color: tan\">b[ar]</span></span>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"display:block; background-color:rgb(0, 255, 255)\"><span style=\"display:block; background-color:rgb(210, 180, 140)\">b<span style=\"background-color:rgb(0, 255, 255)\">[ar]</span></span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"display: block; background-color: aqua\"><span style=\"display: block; background-color: tan\">b[ar]</span></span>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"display:block; background-color:rgb(0, 255, 255)\"><span style=\"display:block; background-color:rgb(210, 180, 140)\">b<span style=\"background-color:rgb(0, 255, 255)\">[ar]</span></span></span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["fo[o<span style=background-color:tan>b]ar</span>baz",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span><span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[true,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["fo[o<span style=background-color:tan>b]ar</span>baz",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span><span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[true,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>ba[r</span>b]az",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "foo<span style=\"background-color:rgb(210, 180, 140)\">ba<span style=\"background-color:rgb(0, 255, 255)\">[r</span></span><span style=\"background-color:rgb(0, 255, 255)\">b]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[true,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>ba[r</span>b]az",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "foo<span style=\"background-color:rgb(210, 180, 140)\">ba<span style=\"background-color:rgb(0, 255, 255)\">[r</span></span><span style=\"background-color:rgb(0, 255, 255)\">b]</span>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[true,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["fo[o<span style=background-color:tan>bar</span>b]az",
    [["hilitecolor","#00FFFF"]],
    "fo<span style=\"background-color:rgb(0, 255, 255)\">[obarb]</span>az",
    [true],
    {"hilitecolor":[true,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[<span style=background-color:tan>b]ar</span>baz",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "foo[<span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo[<span style=background-color:tan>b]ar</span>baz",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "foo[<span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>ba[r</span>]baz",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "foo<span style=\"background-color:rgb(210, 180, 140)\">ba<span style=\"background-color:rgb(0, 255, 255)\">[r</span></span>]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>ba[r</span>]baz",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "foo<span style=\"background-color:rgb(210, 180, 140)\">ba<span style=\"background-color:rgb(0, 255, 255)\">[r</span></span>]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo[<span style=background-color:tan>bar</span>]baz",
    [["hilitecolor","#00FFFF"]],
    "foo[<span style=\"background-color:rgb(0, 255, 255)\">bar</span>]baz",
    [true],
    {"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>[bar]</span>baz",
    [["hilitecolor","#00FFFF"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz",
    [true],
    {"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo{<span style=background-color:tan>bar</span>}baz",
    [["hilitecolor","#00FFFF"]],
    "foo{<span style=\"background-color:rgb(0, 255, 255)\">bar}</span>baz",
    [true],
    {"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o</span><span style=background-color:yellow>b]ar</span>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span></span><span style=\"background-color:rgb(255, 255, 0)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[true,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o</span><span style=background-color:yellow>b]ar</span>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span></span><span style=\"background-color:rgb(255, 255, 0)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[true,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o</span><span style=background-color:tan>b]ar</span>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span></span><span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o</span><span style=background-color:tan>b]ar</span>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span></span><span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o<span style=background-color:transparent>b]ar</span></span>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span><span style=\"background-color:rgba(0, 0, 0, 0)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o<span style=background-color:transparent>b]ar</span></span>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span><span style=\"background-color:rgba(0, 0, 0, 0)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span></span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<font size=6>[foo]</font>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    ["<font size=\"6\" style=\"background-color:rgb(0, 255, 255)\">foo</font>",
     "<font style=\"background-color:rgb(0, 255, 255)\" size=\"6\">foo</font>"],
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<font size=6>[foo]</font>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    ["<font size=\"6\" style=\"background-color:rgb(0, 255, 255)\">foo</font>",
     "<font style=\"background-color:rgb(0, 255, 255)\" size=\"6\">foo</font>"],
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span style=font-size:xx-large>[foo]</span>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"font-size:xx-large; background-color:rgb(0, 255, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span style=font-size:xx-large>[foo]</span>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"font-size:xx-large; background-color:rgb(0, 255, 255)\">[foo]</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<font size=6>foo[bar]baz</font>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<font size=\"6\">foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz</font>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<font size=6>foo[bar]baz</font>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<font size=\"6\">foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span style=font-size:xx-large>foo[bar]baz</span>",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"font-size:xx-large\">foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span style=font-size:xx-large>foo[bar]baz</span>",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"font-size:xx-large\">foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["[foo<font size=6>bar</font>baz]",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">[foo<font size=\"6\">bar</font>baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["[foo<font size=6>bar</font>baz]",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">[foo<font size=\"6\">bar</font>baz]</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["[foo<span style=font-size:xx-large>bar</span>baz]",
    [["stylewithcss","true"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">[foo<span style=\"font-size:xx-large\">bar</span>baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["[foo<span style=font-size:xx-large>bar</span>baz]",
    [["stylewithcss","false"],["hilitecolor","#00FFFF"]],
    "<span style=\"background-color:rgb(0, 255, 255)\">[foo<span style=\"font-size:xx-large\">bar</span>baz]</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}]
]
