;; Test all the f32 operators on major boundary values and all special
;; values (except comparison operators, which are tested in f32_cmp.wast).

(module
  (func $add (param $x f32) (param $y f32) (result f32) (f32.add (get_local $x) (get_local $y)))
  (func $sub (param $x f32) (param $y f32) (result f32) (f32.sub (get_local $x) (get_local $y)))
  (func $mul (param $x f32) (param $y f32) (result f32) (f32.mul (get_local $x) (get_local $y)))
  (func $div (param $x f32) (param $y f32) (result f32) (f32.div (get_local $x) (get_local $y)))
  (func $sqrt (param $x f32) (result f32) (f32.sqrt (get_local $x)))
  (func $min (param $x f32) (param $y f32) (result f32) (f32.min (get_local $x) (get_local $y)))
  (func $max (param $x f32) (param $y f32) (result f32) (f32.max (get_local $x) (get_local $y)))
  (func $ceil (param $x f32) (result f32) (f32.ceil (get_local $x)))
  (func $floor (param $x f32) (result f32) (f32.floor (get_local $x)))
  (func $trunc (param $x f32) (result f32) (f32.trunc (get_local $x)))
  (func $nearest (param $x f32) (result f32) (f32.nearest (get_local $x)))
  (func $abs (param $x f32) (result f32) (f32.abs (get_local $x)))
  (func $neg (param $x f32) (result f32) (f32.neg (get_local $x)))
  (func $copysign (param $x f32) (param $y f32) (result f32) (f32.copysign (get_local $x) (get_local $y)))

  (export "add" $add)
  (export "sub" $sub)
  (export "mul" $mul)
  (export "div" $div)
  (export "sqrt" $sqrt)
  (export "min" $min)
  (export "max" $max)
  (export "ceil" $ceil)
  (export "floor" $floor)
  (export "trunc" $trunc)
  (export "nearest" $nearest)
  (export "abs" $abs)
  (export "neg" $neg)
  (export "copysign" $copysign)
)

(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -0x0p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const 0x0p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const -0x1p-148))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x1p-148))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1.000002p-126))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1.fffffcp-127))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1.fffffcp-127))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1.000002p-126))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -0x1p-149) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const 0x1p-149) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1.000002p-126))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const -0x1.fffffcp-127))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const 0x1.fffffcp-127))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1.000002p-126))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const -0x1p-125))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x1p-125))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -0x1p-126) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const 0x1p-126) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1.8p+0))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1.8p+0))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.b21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.721fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.721fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.b21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -0x1p-1) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const 0x1p-1) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1.8p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1.8p+0))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+1))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+1))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.d21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.521fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.521fb6p+2))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.d21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -0x1p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const 0x1p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1.b21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const -0x1.721fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const 0x1.721fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1.b21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1.d21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const -0x1.521fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const 0x1.521fb6p+2))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1.d21fb6p+2))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+3))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+3))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const -infinity) (f32.const -0x0p+0)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const 0x0p+0)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const -0x0p+0)) (f32.const infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const 0x0p+0)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const -0x1p-149)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const 0x1p-149)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const -0x1p-149)) (f32.const infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const 0x1p-149)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const -0x1p-126)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const 0x1p-126)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const -0x1p-126)) (f32.const infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const 0x1p-126)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const -0x1p-1)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const 0x1p-1)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const -0x1p-1)) (f32.const infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const 0x1p-1)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const -0x1p+0)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const 0x1p+0)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const -0x1p+0)) (f32.const infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const 0x1p+0)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const -0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "add" (f32.const infinity) (f32.const 0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const -infinity)) (f32.const -infinity))
(assert_return_nan (invoke "add" (f32.const -infinity) (f32.const infinity)))
(assert_return_nan (invoke "add" (f32.const infinity) (f32.const -infinity)))
(assert_return (invoke "add" (f32.const infinity) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "add" (f32.const -infinity) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -infinity) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const infinity) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "add" (f32.const infinity) (f32.const nan)) (f32.const nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x0p+0)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x0p+0)) (f32.const -nan))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x0p+0)) (f32.const nan))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x1p-149)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x1p-149)) (f32.const -nan))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x1p-149)) (f32.const nan))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x1p-126)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x1p-126)) (f32.const -nan))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x1p-126)) (f32.const nan))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x1p-1)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x1p-1)) (f32.const -nan))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x1p-1)) (f32.const nan))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x1p+0)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x1p+0)) (f32.const -nan))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x1p+0)) (f32.const nan))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "add" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "add" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const -infinity)) (f32.const -nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const infinity)) (f32.const -nan))
(assert_return (invoke "add" (f32.const nan) (f32.const -infinity)) (f32.const nan))
(assert_return (invoke "add" (f32.const nan) (f32.const infinity)) (f32.const nan))
(assert_return (invoke "add" (f32.const -nan) (f32.const -nan)) (f32.const -nan))
(assert_return_nan (invoke "add" (f32.const -nan) (f32.const nan)))
(assert_return_nan (invoke "add" (f32.const nan) (f32.const -nan)))
(assert_return (invoke "add" (f32.const nan) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -0x0p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const 0x0p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const -0x1p-148))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const 0x1p-148))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const 0x1.fffffcp-127))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const -0x1.000002p-126))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const 0x1.000002p-126))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const -0x1.fffffcp-127))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -0x1p-149) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const 0x1p-149) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1.fffffcp-127))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const -0x1.000002p-126))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const 0x1.000002p-126))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1.fffffcp-127))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const -0x1p-125))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const 0x1p-125))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -0x1p-126) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const 0x1p-126) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const -0x1.8p+0))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const 0x1.8p+0))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.721fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.b21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.b21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.721fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -0x1p-1) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const 0x1p-1) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const -0x1.8p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const 0x1.8p+0))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const -0x1p+1))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const 0x1p+1))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.521fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.d21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.d21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.521fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -0x1p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const 0x1p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1.721fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const -0x1.b21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const 0x1.b21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1.721fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1.521fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const -0x1.d21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const 0x1.d21fb6p+2))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1.521fb6p+2))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+3))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+3))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const -0x0p+0)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const 0x0p+0)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const -0x0p+0)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const 0x0p+0)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const -0x1p-149)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const 0x1p-149)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const -0x1p-149)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const 0x1p-149)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const -0x1p-126)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const 0x1p-126)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const -0x1p-126)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const 0x1p-126)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const -0x1p-1)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const 0x1p-1)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const -0x1p-1)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const 0x1p-1)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const -0x1p+0)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const 0x1p+0)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const -0x1p+0)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const 0x1p+0)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const -0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const 0x1.fffffep+127)) (f32.const infinity))
(assert_return_nan (invoke "sub" (f32.const -infinity) (f32.const -infinity)))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "sub" (f32.const infinity) (f32.const -infinity)) (f32.const infinity))
(assert_return_nan (invoke "sub" (f32.const infinity) (f32.const infinity)))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -infinity) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const infinity) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const infinity) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x0p+0)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x0p+0)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x0p+0)) (f32.const nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x1p-149)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x1p-149)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x1p-149)) (f32.const nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x1p-126)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x1p-126)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x1p-126)) (f32.const nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x1p-1)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x1p-1)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x1p-1)) (f32.const nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x1p+0)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x1p+0)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x1p+0)) (f32.const nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -infinity)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const infinity)) (f32.const -nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const -infinity)) (f32.const nan))
(assert_return (invoke "sub" (f32.const nan) (f32.const infinity)) (f32.const nan))
(assert_return (invoke "sub" (f32.const -nan) (f32.const -nan)) (f32.const -nan))
(assert_return_nan (invoke "sub" (f32.const -nan) (f32.const nan)))
(assert_return_nan (invoke "sub" (f32.const nan) (f32.const -nan)))
(assert_return (invoke "sub" (f32.const nan) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return_nan (invoke "mul" (f32.const -0x0p+0) (f32.const -infinity)))
(assert_return_nan (invoke "mul" (f32.const -0x0p+0) (f32.const infinity)))
(assert_return_nan (invoke "mul" (f32.const 0x0p+0) (f32.const -infinity)))
(assert_return_nan (invoke "mul" (f32.const 0x0p+0) (f32.const infinity)))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -0x0p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const 0x0p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.8p-147))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.8p-147))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.8p-147))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.8p-147))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -0x1p-149) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const 0x1p-149) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const 0x1p-127))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const -0x1p-127))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-127))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-127))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -0x1p-126) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const 0x1p-126) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const 0x1p-127))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const -0x1p-127))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-127))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-127))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const 0x1p-2))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const -0x1p-2))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p-2))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p-2))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -0x1p-1) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const 0x1p-1) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -0x1p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const 0x1p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const 0x1.8p-147))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const -0x1.8p-147))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1.8p-147))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1.8p-147))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const 0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const -0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1.921fb6p-124))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const 0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const -0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1.921fb6p+1))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.3bd3cep+5))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.3bd3cep+5))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.3bd3cep+5))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.3bd3cep+5))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const 0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const -0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1.fffffep-22))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const 0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const -0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1.fffffep+1))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const 0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const -0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1.fffffep+126))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const nan))
(assert_return_nan (invoke "mul" (f32.const -infinity) (f32.const -0x0p+0)))
(assert_return_nan (invoke "mul" (f32.const -infinity) (f32.const 0x0p+0)))
(assert_return_nan (invoke "mul" (f32.const infinity) (f32.const -0x0p+0)))
(assert_return_nan (invoke "mul" (f32.const infinity) (f32.const 0x0p+0)))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const -0x1p-149)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const 0x1p-149)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const -0x1p-149)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const 0x1p-149)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const -0x1p-126)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const 0x1p-126)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const -0x1p-126)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const 0x1p-126)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const -0x1p-1)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const 0x1p-1)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const -0x1p-1)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const 0x1p-1)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const -0x1p+0)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const 0x1p+0)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const -0x1p+0)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const 0x1p+0)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const -0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const 0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "mul" (f32.const infinity) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -infinity) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const infinity) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const infinity) (f32.const nan)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x0p+0)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x0p+0)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x0p+0)) (f32.const nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x1p-149)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x1p-149)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x1p-149)) (f32.const nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x1p-126)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x1p-126)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x1p-126)) (f32.const nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x1p-1)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x1p-1)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x1p-1)) (f32.const nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x1p+0)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x1p+0)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x1p+0)) (f32.const nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -infinity)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const infinity)) (f32.const -nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const -infinity)) (f32.const nan))
(assert_return (invoke "mul" (f32.const nan) (f32.const infinity)) (f32.const nan))
(assert_return (invoke "mul" (f32.const -nan) (f32.const -nan)) (f32.const -nan))
(assert_return_nan (invoke "mul" (f32.const -nan) (f32.const nan)))
(assert_return_nan (invoke "mul" (f32.const nan) (f32.const -nan)))
(assert_return (invoke "mul" (f32.const nan) (f32.const nan)) (f32.const nan))
(assert_return_nan (invoke "div" (f32.const -0x0p+0) (f32.const -0x0p+0)))
(assert_return_nan (invoke "div" (f32.const -0x0p+0) (f32.const 0x0p+0)))
(assert_return_nan (invoke "div" (f32.const 0x0p+0) (f32.const -0x0p+0)))
(assert_return_nan (invoke "div" (f32.const 0x0p+0) (f32.const 0x0p+0)))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -0x0p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const 0x0p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const 0x1p-23))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const -0x1p-23))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1p-23))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1p-23))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const 0x1p-148))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const -0x1p-148))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-148))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-148))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -0x1p-149) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const 0x1p-149) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const 0x1p+23))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const -0x1p+23))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1p+23))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1p+23))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const 0x1p-125))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const -0x1p-125))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-125))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-125))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.45f3p-129))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.45f3p-129))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.45f3p-129))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.45f3p-129))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -0x1p-126) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const 0x1p-126) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const 0x1p+125))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const -0x1p+125))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p+125))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p+125))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.45f306p-4))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.45f306p-4))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.45f306p-4))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.45f306p-4))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const 0x1p-129))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const -0x1p-129))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-129))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-129))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -0x1p-1) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const 0x1p-1) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const 0x1p+126))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const -0x1p+126))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p+126))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p+126))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const 0x1p+1))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const -0x1p+1))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p+1))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p+1))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.45f306p-3))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.45f306p-3))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.45f306p-3))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.45f306p-3))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1p-128))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1p-128))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-128))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-128))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -0x1p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const 0x1p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const 0x1.921fb6p+3))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const -0x1.921fb6p+3))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1.921fb6p+3))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1.921fb6p+3))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const 0x1.921fb8p-126))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const -0x1.921fb8p-126))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.921fb8p-126))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.921fb8p-126))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.45f304p+125))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.45f304p+125))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.45f304p+125))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.45f304p+125))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -0x1p+0))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x1p+0))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (f32.const -0x0p+0))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const infinity)) (f32.const 0x0p+0))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const -infinity) (f32.const -0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const 0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const -0x0p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const 0x0p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const -0x1p-149)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const 0x1p-149)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const -0x1p-149)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const 0x1p-149)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const -0x1p-126)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const 0x1p-126)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const -0x1p-126)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const 0x1p-126)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const -0x1p-1)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const 0x1p-1)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const -0x1p-1)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const 0x1p-1)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const -0x1p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const 0x1p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const -0x1p+0)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const 0x1p+0)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "div" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const -0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "div" (f32.const infinity) (f32.const 0x1.fffffep+127)) (f32.const infinity))
(assert_return_nan (invoke "div" (f32.const -infinity) (f32.const -infinity)))
(assert_return_nan (invoke "div" (f32.const -infinity) (f32.const infinity)))
(assert_return_nan (invoke "div" (f32.const infinity) (f32.const -infinity)))
(assert_return_nan (invoke "div" (f32.const infinity) (f32.const infinity)))
(assert_return (invoke "div" (f32.const -infinity) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -infinity) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const infinity) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "div" (f32.const infinity) (f32.const nan)) (f32.const nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x0p+0)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x0p+0)) (f32.const -nan))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x0p+0)) (f32.const nan))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x1p-149)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x1p-149)) (f32.const -nan))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x1p-149)) (f32.const nan))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x1p-126)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x1p-126)) (f32.const -nan))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x1p-126)) (f32.const nan))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x1p-1)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x1p-1)) (f32.const -nan))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x1p-1)) (f32.const nan))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x1p+0)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x1p+0)) (f32.const -nan))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x1p+0)) (f32.const nan))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "div" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "div" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const -infinity)) (f32.const -nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const infinity)) (f32.const -nan))
(assert_return (invoke "div" (f32.const nan) (f32.const -infinity)) (f32.const nan))
(assert_return (invoke "div" (f32.const nan) (f32.const infinity)) (f32.const nan))
(assert_return (invoke "div" (f32.const -nan) (f32.const -nan)) (f32.const -nan))
(assert_return_nan (invoke "div" (f32.const -nan) (f32.const nan)))
(assert_return_nan (invoke "div" (f32.const nan) (f32.const -nan)))
(assert_return (invoke "div" (f32.const nan) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const infinity)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const infinity)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -0x0p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const 0x0p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const infinity)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const infinity)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -0x1p-149) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const 0x1p-149) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const infinity)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const infinity)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -0x1p-126) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const 0x1p-126) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const infinity)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const infinity)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -0x1p-1) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const 0x1p-1) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const infinity)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const infinity)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -0x1p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const 0x1p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const infinity)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const infinity)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const -infinity) (f32.const -0x0p+0)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -infinity) (f32.const 0x0p+0)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const infinity) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "min" (f32.const infinity) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "min" (f32.const -infinity) (f32.const -0x1p-149)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -infinity) (f32.const 0x1p-149)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const infinity) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "min" (f32.const infinity) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "min" (f32.const -infinity) (f32.const -0x1p-126)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -infinity) (f32.const 0x1p-126)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const infinity) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "min" (f32.const infinity) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "min" (f32.const -infinity) (f32.const -0x1p-1)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -infinity) (f32.const 0x1p-1)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const infinity) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "min" (f32.const infinity) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "min" (f32.const -infinity) (f32.const -0x1p+0)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -infinity) (f32.const 0x1p+0)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const infinity) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "min" (f32.const infinity) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "min" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "min" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const infinity) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "min" (f32.const infinity) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "min" (f32.const -infinity) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const -infinity) (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const infinity) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "min" (f32.const infinity) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "min" (f32.const -infinity) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -infinity) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const infinity) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "min" (f32.const infinity) (f32.const nan)) (f32.const nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x0p+0)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x0p+0)) (f32.const -nan))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x0p+0)) (f32.const nan))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x1p-149)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x1p-149)) (f32.const -nan))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x1p-149)) (f32.const nan))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x1p-126)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x1p-126)) (f32.const -nan))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x1p-126)) (f32.const nan))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x1p-1)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x1p-1)) (f32.const -nan))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x1p-1)) (f32.const nan))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x1p+0)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x1p+0)) (f32.const -nan))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x1p+0)) (f32.const nan))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "min" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "min" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const -infinity)) (f32.const -nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const infinity)) (f32.const -nan))
(assert_return (invoke "min" (f32.const nan) (f32.const -infinity)) (f32.const nan))
(assert_return (invoke "min" (f32.const nan) (f32.const infinity)) (f32.const nan))
(assert_return (invoke "min" (f32.const -nan) (f32.const -nan)) (f32.const -nan))
(assert_return_nan (invoke "min" (f32.const -nan) (f32.const nan)))
(assert_return_nan (invoke "min" (f32.const nan) (f32.const -nan)))
(assert_return (invoke "min" (f32.const nan) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -infinity)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -infinity)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -0x0p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const 0x0p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -infinity)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -infinity)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -0x1p-149) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const 0x1p-149) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -infinity)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -infinity)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -0x1p-126) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const 0x1p-126) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -infinity)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -infinity)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -0x1p-1) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const 0x1p-1) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -infinity)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -infinity)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -0x1p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const 0x1p+0) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const -infinity) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "max" (f32.const -infinity) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "max" (f32.const infinity) (f32.const -0x0p+0)) (f32.const infinity))
(assert_return (invoke "max" (f32.const infinity) (f32.const 0x0p+0)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -infinity) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "max" (f32.const -infinity) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "max" (f32.const infinity) (f32.const -0x1p-149)) (f32.const infinity))
(assert_return (invoke "max" (f32.const infinity) (f32.const 0x1p-149)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -infinity) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "max" (f32.const -infinity) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "max" (f32.const infinity) (f32.const -0x1p-126)) (f32.const infinity))
(assert_return (invoke "max" (f32.const infinity) (f32.const 0x1p-126)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -infinity) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "max" (f32.const -infinity) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "max" (f32.const infinity) (f32.const -0x1p-1)) (f32.const infinity))
(assert_return (invoke "max" (f32.const infinity) (f32.const 0x1p-1)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -infinity) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "max" (f32.const -infinity) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "max" (f32.const infinity) (f32.const -0x1p+0)) (f32.const infinity))
(assert_return (invoke "max" (f32.const infinity) (f32.const 0x1p+0)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "max" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "max" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "max" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "max" (f32.const infinity) (f32.const -0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "max" (f32.const infinity) (f32.const 0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -infinity) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "max" (f32.const -infinity) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const infinity) (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const infinity) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "max" (f32.const -infinity) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -infinity) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const infinity) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "max" (f32.const infinity) (f32.const nan)) (f32.const nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x0p+0)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x0p+0)) (f32.const -nan))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x0p+0)) (f32.const nan))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x1p-149)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x1p-149)) (f32.const -nan))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x1p-149)) (f32.const nan))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x1p-126)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x1p-126)) (f32.const -nan))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x1p-126)) (f32.const nan))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x1p-1)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x1p-1)) (f32.const -nan))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x1p-1)) (f32.const nan))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x1p+0)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x1p+0)) (f32.const -nan))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x1p+0)) (f32.const nan))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "max" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "max" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const -infinity)) (f32.const -nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const infinity)) (f32.const -nan))
(assert_return (invoke "max" (f32.const nan) (f32.const -infinity)) (f32.const nan))
(assert_return (invoke "max" (f32.const nan) (f32.const infinity)) (f32.const nan))
(assert_return (invoke "max" (f32.const -nan) (f32.const -nan)) (f32.const -nan))
(assert_return_nan (invoke "max" (f32.const -nan) (f32.const nan)))
(assert_return_nan (invoke "max" (f32.const nan) (f32.const -nan)))
(assert_return (invoke "max" (f32.const nan) (f32.const nan)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const -0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const 0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const -0x1p+0)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const 0x1p+0)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const -infinity)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const infinity)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const -infinity)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const infinity)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const -nan)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x0p+0) (f32.const nan)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const -nan)) (f32.const -0x0p+0))
(assert_return (invoke "copysign" (f32.const 0x0p+0) (f32.const nan)) (f32.const 0x0p+0))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const -0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const 0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const -0x0p+0)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const 0x0p+0)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const -0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const -0x1p-126)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const 0x1p-126)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const -0x1p-1)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const 0x1p-1)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const -0x1p+0)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const 0x1p+0)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const -infinity)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const infinity)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const -infinity)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const infinity)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const -nan)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-149) (f32.const nan)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const -nan)) (f32.const -0x1p-149))
(assert_return (invoke "copysign" (f32.const 0x1p-149) (f32.const nan)) (f32.const 0x1p-149))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const -0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const 0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const -0x0p+0)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const 0x0p+0)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const -0x1p-149)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const 0x1p-149)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const -0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const -0x1p-1)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const 0x1p-1)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const -0x1p+0)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const 0x1p+0)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const -infinity)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const infinity)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const -infinity)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const infinity)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const -nan)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-126) (f32.const nan)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const -nan)) (f32.const -0x1p-126))
(assert_return (invoke "copysign" (f32.const 0x1p-126) (f32.const nan)) (f32.const 0x1p-126))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const -0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const 0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const -0x0p+0)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const 0x0p+0)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const -0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const 0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const -0x1p-149)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const 0x1p-149)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const -0x1p-126)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const 0x1p-126)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const -0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const -0x1p+0)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const 0x1p+0)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const -infinity)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const infinity)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const -infinity)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const infinity)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const -nan)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p-1) (f32.const nan)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const -nan)) (f32.const -0x1p-1))
(assert_return (invoke "copysign" (f32.const 0x1p-1) (f32.const nan)) (f32.const 0x1p-1))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const -0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const 0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const -0x0p+0)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const 0x0p+0)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const -0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const 0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const -0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const 0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const -0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const 0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const -infinity)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const infinity)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const -infinity)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const infinity)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const -nan)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1p+0) (f32.const nan)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const -nan)) (f32.const -0x1p+0))
(assert_return (invoke "copysign" (f32.const 0x1p+0) (f32.const nan)) (f32.const 0x1p+0))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.921fb6p+2) (f32.const nan)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const 0x1.921fb6p+2) (f32.const nan)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const infinity)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const infinity)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const -nan)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -0x1.fffffep+127) (f32.const nan)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const -nan)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const 0x1.fffffep+127) (f32.const nan)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const -0x0p+0)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const 0x0p+0)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const -0x0p+0)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const 0x0p+0)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const -0x1p-149)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const 0x1p-149)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const -0x1p-149)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const 0x1p-149)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const -0x1p-126)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const 0x1p-126)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const -0x1p-126)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const 0x1p-126)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const -0x1p-1)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const 0x1p-1)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const -0x1p-1)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const 0x1p-1)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const -0x1p+0)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const 0x1p+0)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const -0x1p+0)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const 0x1p+0)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const -0x1.fffffep+127)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const 0x1.fffffep+127)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const -nan)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const -infinity) (f32.const nan)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const -nan)) (f32.const -infinity))
(assert_return (invoke "copysign" (f32.const infinity) (f32.const nan)) (f32.const infinity))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const -0x0p+0)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const 0x0p+0)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const -0x0p+0)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const 0x0p+0)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const -0x1p-149)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const 0x1p-149)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const -0x1p-149)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const 0x1p-149)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const -0x1p-126)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const 0x1p-126)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const -0x1p-126)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const 0x1p-126)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const -0x1p-1)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const 0x1p-1)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const -0x1p-1)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const 0x1p-1)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const -0x1p+0)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const 0x1p+0)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const -0x1p+0)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const 0x1p+0)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const -0x1.921fb6p+2)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const 0x1.921fb6p+2)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const -0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const 0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const -0x1.fffffep+127)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const 0x1.fffffep+127)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const -infinity)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const infinity)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const -infinity)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const infinity)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const -nan) (f32.const nan)) (f32.const nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "copysign" (f32.const nan) (f32.const nan)) (f32.const nan))
(assert_return (invoke "sqrt" (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "sqrt" (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return_nan (invoke "sqrt" (f32.const -0x1p-149)))
(assert_return (invoke "sqrt" (f32.const 0x1p-149)) (f32.const 0x1.6a09e6p-75))
(assert_return_nan (invoke "sqrt" (f32.const -0x1p-126)))
(assert_return (invoke "sqrt" (f32.const 0x1p-126)) (f32.const 0x1p-63))
(assert_return_nan (invoke "sqrt" (f32.const -0x1p-1)))
(assert_return (invoke "sqrt" (f32.const 0x1p-1)) (f32.const 0x1.6a09e6p-1))
(assert_return_nan (invoke "sqrt" (f32.const -0x1p+0)))
(assert_return (invoke "sqrt" (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return_nan (invoke "sqrt" (f32.const -0x1.921fb6p+2)))
(assert_return (invoke "sqrt" (f32.const 0x1.921fb6p+2)) (f32.const 0x1.40d932p+1))
(assert_return_nan (invoke "sqrt" (f32.const -0x1.fffffep+127)))
(assert_return (invoke "sqrt" (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+63))
(assert_return_nan (invoke "sqrt" (f32.const -infinity)))
(assert_return (invoke "sqrt" (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "sqrt" (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "sqrt" (f32.const nan)) (f32.const nan))
(assert_return (invoke "floor" (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "floor" (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "floor" (f32.const -0x1p-149)) (f32.const -0x1p+0))
(assert_return (invoke "floor" (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "floor" (f32.const -0x1p-126)) (f32.const -0x1p+0))
(assert_return (invoke "floor" (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "floor" (f32.const -0x1p-1)) (f32.const -0x1p+0))
(assert_return (invoke "floor" (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "floor" (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "floor" (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "floor" (f32.const -0x1.921fb6p+2)) (f32.const -0x1.cp+2))
(assert_return (invoke "floor" (f32.const 0x1.921fb6p+2)) (f32.const 0x1.8p+2))
(assert_return (invoke "floor" (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "floor" (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "floor" (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "floor" (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "floor" (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "floor" (f32.const nan)) (f32.const nan))
(assert_return (invoke "ceil" (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "ceil" (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "ceil" (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "ceil" (f32.const 0x1p-149)) (f32.const 0x1p+0))
(assert_return (invoke "ceil" (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "ceil" (f32.const 0x1p-126)) (f32.const 0x1p+0))
(assert_return (invoke "ceil" (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "ceil" (f32.const 0x1p-1)) (f32.const 0x1p+0))
(assert_return (invoke "ceil" (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "ceil" (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "ceil" (f32.const -0x1.921fb6p+2)) (f32.const -0x1.8p+2))
(assert_return (invoke "ceil" (f32.const 0x1.921fb6p+2)) (f32.const 0x1.cp+2))
(assert_return (invoke "ceil" (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "ceil" (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "ceil" (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "ceil" (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "ceil" (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "ceil" (f32.const nan)) (f32.const nan))
(assert_return (invoke "trunc" (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "trunc" (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "trunc" (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "trunc" (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "trunc" (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "trunc" (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "trunc" (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "trunc" (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "trunc" (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "trunc" (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "trunc" (f32.const -0x1.921fb6p+2)) (f32.const -0x1.8p+2))
(assert_return (invoke "trunc" (f32.const 0x1.921fb6p+2)) (f32.const 0x1.8p+2))
(assert_return (invoke "trunc" (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "trunc" (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "trunc" (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "trunc" (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "trunc" (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "trunc" (f32.const nan)) (f32.const nan))
(assert_return (invoke "nearest" (f32.const -0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "nearest" (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "nearest" (f32.const -0x1p-149)) (f32.const -0x0p+0))
(assert_return (invoke "nearest" (f32.const 0x1p-149)) (f32.const 0x0p+0))
(assert_return (invoke "nearest" (f32.const -0x1p-126)) (f32.const -0x0p+0))
(assert_return (invoke "nearest" (f32.const 0x1p-126)) (f32.const 0x0p+0))
(assert_return (invoke "nearest" (f32.const -0x1p-1)) (f32.const -0x0p+0))
(assert_return (invoke "nearest" (f32.const 0x1p-1)) (f32.const 0x0p+0))
(assert_return (invoke "nearest" (f32.const -0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "nearest" (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "nearest" (f32.const -0x1.921fb6p+2)) (f32.const -0x1.8p+2))
(assert_return (invoke "nearest" (f32.const 0x1.921fb6p+2)) (f32.const 0x1.8p+2))
(assert_return (invoke "nearest" (f32.const -0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "nearest" (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "nearest" (f32.const -infinity)) (f32.const -infinity))
(assert_return (invoke "nearest" (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "nearest" (f32.const -nan)) (f32.const -nan))
(assert_return (invoke "nearest" (f32.const nan)) (f32.const nan))
(assert_return (invoke "abs" (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "abs" (f32.const 0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "abs" (f32.const -0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "abs" (f32.const 0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "abs" (f32.const -0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "abs" (f32.const 0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "abs" (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "abs" (f32.const 0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "abs" (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "abs" (f32.const 0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "abs" (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "abs" (f32.const 0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "abs" (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "abs" (f32.const 0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "abs" (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "abs" (f32.const infinity)) (f32.const infinity))
(assert_return (invoke "abs" (f32.const -nan)) (f32.const nan))
(assert_return (invoke "abs" (f32.const nan)) (f32.const nan))
(assert_return (invoke "neg" (f32.const -0x0p+0)) (f32.const 0x0p+0))
(assert_return (invoke "neg" (f32.const 0x0p+0)) (f32.const -0x0p+0))
(assert_return (invoke "neg" (f32.const -0x1p-149)) (f32.const 0x1p-149))
(assert_return (invoke "neg" (f32.const 0x1p-149)) (f32.const -0x1p-149))
(assert_return (invoke "neg" (f32.const -0x1p-126)) (f32.const 0x1p-126))
(assert_return (invoke "neg" (f32.const 0x1p-126)) (f32.const -0x1p-126))
(assert_return (invoke "neg" (f32.const -0x1p-1)) (f32.const 0x1p-1))
(assert_return (invoke "neg" (f32.const 0x1p-1)) (f32.const -0x1p-1))
(assert_return (invoke "neg" (f32.const -0x1p+0)) (f32.const 0x1p+0))
(assert_return (invoke "neg" (f32.const 0x1p+0)) (f32.const -0x1p+0))
(assert_return (invoke "neg" (f32.const -0x1.921fb6p+2)) (f32.const 0x1.921fb6p+2))
(assert_return (invoke "neg" (f32.const 0x1.921fb6p+2)) (f32.const -0x1.921fb6p+2))
(assert_return (invoke "neg" (f32.const -0x1.fffffep+127)) (f32.const 0x1.fffffep+127))
(assert_return (invoke "neg" (f32.const 0x1.fffffep+127)) (f32.const -0x1.fffffep+127))
(assert_return (invoke "neg" (f32.const -infinity)) (f32.const infinity))
(assert_return (invoke "neg" (f32.const infinity)) (f32.const -infinity))
(assert_return (invoke "neg" (f32.const -nan)) (f32.const nan))
(assert_return (invoke "neg" (f32.const nan)) (f32.const -nan))
